/*
 * @(#)SimulatedStream.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.dml.model;

import java.beans.*;
import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import java.io.IOException;
import java.util.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * SimulatedStream.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18 Created.
 */
public class SimulatedStream extends AbstractRelationship
        implements DataSourceListener, DataSinkListener {
    
    /** Creates a new instance. */
    public SimulatedStream() {
    }
    
    public DataSource getDataSource() {
        return (DataSource) getStart();
    }
    public DataSink getDataSink() {
        return (DataSink) getEnd();
    }
    
    public int getSimulatedConcept() {
        return DMLModel.STREAM;
    }
    
    public boolean canConnect(SimulatedElement start, SimulatedElement end) {
        // FIXME - Test for loops
        if (start != end &&
                (start instanceof DataSource) &&
                (end instanceof DataSink) &&
                start.getSimulatedConcept() != end.getSimulatedConcept() &&
                (start.getSimulatedConcept() == DMLModel.TABLE ||
                start.getSimulatedConcept() == DMLModel.STATEMENT) &&
                (end.getSimulatedConcept() == DMLModel.TABLE ||
                end.getSimulatedConcept() == DMLModel.STATEMENT)
                ) {
            return true;
        }
        return false;
    }
    public boolean canConnect(SimulatedElement start) {
        return start instanceof DataSource &&
                (start.getSimulatedConcept() == DMLModel.TABLE ||
                start.getSimulatedConcept() == DMLModel.STATEMENT)
                ;
    }
    
    public SimulatedStream clone() {
        SimulatedStream that = (SimulatedStream) super.clone();
        return that;
    }
    
    public void read(DOMInput in) throws IOException {
        in.openElement("input");
        setStart((SimulatedElement) in.readObject());
        in.closeElement();
        in.openElement("output");
        setEnd((SimulatedElement) in.readObject());
        in.closeElement();
    }
    public void write(DOMOutput out) throws IOException {
        out.openElement("input");
        out.writeObject(getStart());
        out.closeElement();
        out.openElement("output");
        out.writeObject(getStart());
        out.closeElement();
    }
    
    /**
     * Handles the disconnection of a connection.
     * Override this method to handle this event.
     */
    protected void handleDisconnecting(SimulatedElement start, SimulatedElement end) {
        DataSource s = (DataSource) start;
        DataSink e = (DataSink) end;
        s.removeDataSourceListener(this);
        e.removeDataSinkListener(this);
    }
    
    /**
     * Handles the connection of a connection.
     * Override this method to handle this event.
     */
    protected void handleConnecting(SimulatedElement start, SimulatedElement end) {
        DataSource s = (DataSource) start;
        DataSink e = (DataSink) end;
        s.addDataSourceListener(this);
        e.addDataSinkListener(this);
    }

    public void requestData(DataSinkEvent event) {
    }

    public void dataChanged(DataSourceEvent event) {
    }
}
